IF OBJECT_ID('P_EXP_CTB_MOV_PG_CRED_BANCARIO_JUROS') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_PG_CRED_BANCARIO_JUROS
	END
 
GO 
CREATE PROCEDURE P_EXP_CTB_MOV_PG_CRED_BANCARIO_JUROS(@CD_EMP			INT,
									@CD_FILIAL		INT,
									@DT_INI			DATETIME,
									@DT_FIM			DATETIME,
									@CD_BC_LANC		INT,
									@CODIGO_INTERNO VARCHAR(50) = NULL
								)	
WITH ENCRYPTION AS 

DECLARE @RS_CD_EMP					INT
DECLARE @RS_CD_FILIAL				INT
DECLARE @RS_CD_FORN					INT
DECLARE @RS_HIST					VARCHAR(500)
DECLARE @RS_CD_CNT					INT
DECLARE @RS_NR_CHQ					INT
DECLARE @RS_SERIE_CHQ				VARCHAR(5)
DECLARE @RS_ANO_CHQ					INT
DECLARE @RS_CD_PG_DEB_LOTE			INT
DECLARE @RS_VLR_EMIT_DEST			MONEY
DECLARE @RS_VL_JUR					MONEY
DECLARE @RS_VL_DESC					MONEY
DECLARE @RS_VL_IMP					MONEY
DECLARE @RS_VLR_DESP_OUTR			MONEY
DECLARE @RS_VLR_DEVOLUCAO			MONEY
DECLARE @RS_RZ_FORN					VARCHAR(200)
DECLARE @NR_CNT                     VARCHAR(50)
DECLARE @DS_CNT                     VARCHAR(150) 
DECLARE @CD_BC                      VARCHAR(100) 
DECLARE @DS_BC                      VARCHAR(30)
	
DECLARE @RS_NR_NF					INT 
DECLARE @RS_DT_PAG					DATETIME
DECLARE @RS_VLR_CONTA				MONEY
DECLARE @RS_QTDE_LANC				INT
	
DECLARE @RET_CD_CTB_CNT				VARCHAR(100)
DECLARE @RET_CD_CTB_CNT_RED			INT
DECLARE @RET_DS_CNT					VARCHAR(100)
DECLARE @RET_NR_CNT					VARCHAR(50)	
DECLARE @RET_TITULAR_CNT			VARCHAR(200)
DECLARE @RET_TP_CNT					INT
DECLARE @RS_NR_DP					INT
DECLARE @RS_TIPO_PAGTO              VARCHAR(20)
DECLARE @NUM_DUPL				    VARCHAR (20)
DECLARE @NUMERODUPL                 VARCHAR(20)  
	
DECLARE @RS_NR_TIT					VARCHAR(50)
DECLARE @HIST  			     		VARCHAR(500)

	--#####################################################################
	--CURSOR JUROS
	--#####################################################################			
	DECLARE RS_RESULT_BANCARIO_JUROS
		CURSOR FOR 
			SELECT 	
				CD_EMP,
				CD_FILIAL,
				DT_PAG,
				ROUND(SUM(VL_JUR), 2)  AS VL_JUR	,
				MAX(NR_TIT) AS NR_TIT,
				MAX(NR_DP) AS NR_DP,			
				CD_PG_DEB_LOTE,
				TIPO_PAGTO, 
				HIST,
                NR_CNT,
			    DS_CNT, 
			    CD_BC, 
		        DS_BC
				
			FROM ##RS_RETURN
			WHERE 
				VL_JUR > 0
				AND CD_BC_LANC =@CD_BC_LANC 
			GROUP BY 
				CD_EMP,
				CD_FILIAL,										
				DT_PAG,			
				CD_PG_DEB_LOTE,
				TIPO_PAGTO,
				HIST,
                NR_CNT,
			    DS_CNT, 
			    CD_BC, 
		        DS_BC
				
	--Abrindo cursor
	OPEN RS_RESULT_BANCARIO_JUROS
	
	--Atribuindo valores do select nas variveis
	FETCH NEXT FROM RS_RESULT_BANCARIO_JUROS INTO 
		@RS_CD_EMP,
		@RS_CD_FILIAL,
		@RS_DT_PAG,
		@RS_VL_JUR,
		@RS_NR_TIT,
		@RS_NR_DP,
		@RS_CD_PG_DEB_LOTE,
		@RS_TIPO_PAGTO,
		@RS_HIST,
		@NR_CNT, 
		@DS_CNT ,
		@CD_BC,  
		@DS_BC  
	 
	--Iniciando lao
	WHILE @@FETCH_STATUS = 0		    
		BEGIN	
		
			    SET @CODIGO_INTERNO = CONVERT(VARCHAR, @CD_BC_LANC) + ' - ' + CONVERT(VARCHAR, @RS_CD_FILIAL)

				--SET @HIST = 'JUROS S/ DUPL. RECEB: '+@RS_RZ_CLI+' - REF: c: '+CAST(@RS_PARC AS VARCHAR)+' CONTA: '+@RET_DS_CNT+' - '+@RET_NR_CNT;
                --  EXEC P_EXP_CTB_EXP_MOV_PROC_ALL  1,'1,3,4,5,900','20250401','20250401'
				--  SELECT HIST, DT_GERACAO  FROM CTB_eXP_MOV WHERE VLR_LANC = 19.32  AND DT_MOV = '20250401'                  

				SET @HIST = 'JUROS SOBRE ' + CAST(@RS_HIST AS VARCHAR) + ' Conta: '+ @DS_CNT +' - ' + @NR_CNT +   @CD_BC  + '-' + @DS_BC
		
			 	IF @RS_TIPO_PAGTO = 'LOTE'  
				    BEGIN 
					   SET	@NUM_DUPL  =  @RS_CD_PG_DEB_LOTE   
				    END
				ELSE
				    BEGIN
					   SET @NUMERODUPL =  RIGHT('0000'+ CAST(@RS_CD_FILIAL AS VARCHAR(4)),4) + CAST(@RS_NR_DP AS VARCHAR )
					   SET	@NUM_DUPL  =  @NUMERODUPL 
				END	
 		  			
				INSERT INTO ##CTB_EXP_MOV 

				(CD_EMP,CD_FILIAL_EXPORT,  CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
				CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
				VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
				ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC, 
				COD_INTERNO_DOMINIO)

				SELECT		@RS_CD_EMP										AS CD_EMP,
							@CD_FILIAL										AS CD_FILIAL_EXPORT,
							@RS_CD_FILIAL									AS CD_FILIAL,
							16												AS CD_MOVIMENTO,
							'PAGAMENTO FORNECEDOR'							AS MOVIMENTO,
							''												AS OPERACAO,
							'JUROS DUPL. PAGTO - DEBITO'	            	AS OPERACAO_DEBITO,
							0												AS CD_CNT_RED_CREDITO,
							''												AS CD_CNT_CREDITO,																
							0												AS CD_CNT_RED_DEBITO,
							''												AS CD_CNT_DEBITO,
							@RS_DT_PAG										AS DT_MOV,
			
							@HIST                                           AS HIST,								
							@RS_VL_JUR										AS VLR_LANC,
							'D'												AS TP_TRANSA,
							0 												AS RATEIO_CENTRO_CUSTO,
							'' 												AS DS_CENTRO_CUSTO,
							0 												AS CNT_CENTRO_CUSTO,
							0 												AS VLR_CENTRO_CUSTO,
							'FILIAIS'									    AS ORIG_CONTA,
							16 									    		AS COD_CONTA,
							OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE
							 , 'V' AS TIPO_LANCTO
							 , 0 AS CD_EVENTO
							 , @NUM_DUPL  AS NR_DP
							 , 0  AS ANO
							 , @RS_NR_TIT  AS NR_DOC
							 , 0 AS CD_BC_LANC
							 ,@CODIGO_INTERNO;

			--Atribuindo valores do select nas variveis
			FETCH NEXT FROM RS_RESULT_BANCARIO_JUROS INTO 
				@RS_CD_EMP,
				@RS_CD_FILIAL,
				@RS_DT_PAG,
				@RS_VL_JUR,
				@RS_NR_TIT,
				@RS_NR_DP,
				@RS_CD_PG_DEB_LOTE,
				@RS_TIPO_PAGTO,
				@RS_HIST,
				@NR_CNT ,
				@DS_CNT ,
				@CD_BC , 
				@DS_BC  
							
		END								
			
	CLOSE RS_RESULT_BANCARIO_JUROS
	DEALLOCATE RS_RESULT_BANCARIO_JUROS